/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.launching;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.SafeRunnable;

public class LaunchConfigurationsTabsRegistry {
    private static final String EXTENSION_POINT_NAME = "launchConfigurationTabs";
    private static final String TAB_TAG = "launchConfigurationTab";
    private static final String ID_ATTRIBUTE = "id";
    private static final String GROUP_ID_ATTRIBUTE = "launchConfigurationTabGroupId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PLACE_AFTER_ATTRIBUTE = "placeAfter";
    private static final String MODES_ATTRIBUTE = "modes";
    private List<TabFactory> factories = new ArrayList<TabFactory>(5);
    private static LaunchConfigurationsTabsRegistry instance;

    public static AbstractLaunchConfigurationTab[] getLaunchTabs(String launchConfigurationTabGroupId, String mode) {
        LaunchConfigurationsTabsRegistry registry = LaunchConfigurationsTabsRegistry.getInstance();
        List<TabFactory> fragments = registry.factories;
        ArrayList<AbstractLaunchConfigurationTab> factoriesList = new ArrayList<AbstractLaunchConfigurationTab>();
        int i = 0;
        while (i < fragments.size()) {
            boolean modeOK;
            TabFactory factory = fragments.get(i);
            boolean bl = modeOK = factory.getModes().length() == 0 || factory.getModes().indexOf(mode) > -1;
            if (factory.getGroupID().equals(launchConfigurationTabGroupId) && modeOK) {
                factoriesList.add(factory.createFragmentFactory());
            }
            ++i;
        }
        AbstractLaunchConfigurationTab[] tabs = new AbstractLaunchConfigurationTab[factoriesList.size()];
        factoriesList.toArray(tabs);
        return tabs;
    }

    private LaunchConfigurationsTabsRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.php.debug.epl", EXTENSION_POINT_NAME);
        ArrayList<TabFactory> mightOverride = new ArrayList<TabFactory>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (TAB_TAG.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String groupId = element.getAttribute(GROUP_ID_ATTRIBUTE);
                String placeAfter = element.getAttribute(PLACE_AFTER_ATTRIBUTE);
                String modes = element.getAttribute(MODES_ATTRIBUTE);
                if (element.getNamespaceIdentifier().equals("com.aptana.php.debug.epl") || element.getNamespaceIdentifier().startsWith("org2.eclipse.php.server.")) {
                    this.factories.add(0, new TabFactory(element, groupId, id, placeAfter, modes));
                } else {
                    boolean override = false;
                    int j = 0;
                    while (!override && j < this.factories.size()) {
                        TabFactory factory = this.factories.get(j);
                        if (id.equals(factory.id)) {
                            override = true;
                            if (!element.getNamespaceIdentifier().startsWith("org2.eclipse.php.")) {
                                this.factories.remove(j);
                                this.factories.add(new TabFactory(element, groupId, id, placeAfter, modes));
                                break;
                            }
                        }
                        ++j;
                    }
                    if (!override) {
                        mightOverride.add(new TabFactory(element, groupId, id, placeAfter, modes));
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < mightOverride.size()) {
            TabFactory tag = (TabFactory)mightOverride.get(i);
            int index = this.factories.indexOf(tag);
            if (index > -1) {
                this.factories.set(index, tag);
            } else {
                this.factories.add(tag);
            }
            ++i;
        }
        this.sortFragmentsByPlace();
    }

    private void sortFragmentsByPlace() {
        ArrayList<TabFactory> rootsFragments = new ArrayList<TabFactory>(this.factories.size());
        ArrayList<TabFactory> nonRootFragments = new ArrayList<TabFactory>(this.factories.size());
        int i = 0;
        while (i < this.factories.size()) {
            TabFactory factory = this.factories.get(i);
            if (factory.getPlaceAfter() == null || factory.getPlaceAfter().equals("")) {
                rootsFragments.add(factory);
            } else {
                nonRootFragments.add(factory);
            }
            ++i;
        }
        boolean orderChanged = false;
        do {
            ArrayList<TabFactory> moved = new ArrayList<TabFactory>(nonRootFragments.size());
            for (TabFactory nonRootTab : nonRootFragments) {
                String placeAfter = nonRootTab.getPlaceAfter();
                int i2 = 0;
                while (i2 < rootsFragments.size()) {
                    TabFactory rootTab = (TabFactory)rootsFragments.get(i2);
                    if (placeAfter.equals(rootTab.getID())) {
                        rootsFragments.add(i2 + 1, nonRootTab);
                        moved.add(nonRootTab);
                    }
                    ++i2;
                }
            }
            orderChanged = !moved.isEmpty();
            nonRootFragments.removeAll(moved);
        } while (orderChanged);
        if (!nonRootFragments.isEmpty()) {
            rootsFragments.addAll(nonRootFragments);
            PHPDebugEPLPlugin.logError("Invalid 'placeAfter' id for some of the extending 'launchConfigurationTabs'");
        }
        this.factories.clear();
        this.factories.addAll(rootsFragments);
    }

    private static LaunchConfigurationsTabsRegistry getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationsTabsRegistry();
        }
        return instance;
    }

    private class TabFactory {
        private IConfigurationElement element;
        private AbstractLaunchConfigurationTab factory;
        private String id;
        private String groupId;
        private String placeAfter;
        private String modes;

        public TabFactory(IConfigurationElement element, String groupId, String id, String placeAfter, String modes) {
            this.element = element;
            this.groupId = groupId;
            this.id = id;
            this.placeAfter = placeAfter;
            this.modes = modes;
        }

        public AbstractLaunchConfigurationTab createFragmentFactory() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org2.eclipse.php.server.ui.serverTabs"){

                public void run() throws Exception {
                    TabFactory.this.factory = (AbstractLaunchConfigurationTab)TabFactory.this.element.createExecutableExtension(LaunchConfigurationsTabsRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.factory;
        }

        public String getID() {
            return this.id;
        }

        public String getPlaceAfter() {
            return this.placeAfter;
        }

        public String getGroupID() {
            return this.groupId;
        }

        public String getModes() {
            if (this.modes == null) {
                this.modes = "";
            }
            return this.modes;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof TabFactory) {
                return this.getID().equals(((TabFactory)other).getID());
            }
            return false;
        }
    }
}

